#include "GetPoint.js"

function DoEllipseDiameter()
{
	var ui = moi.ui;
	var pointpicker = ui.createPointPicker();

	if ( !GetPoint( pointpicker ) )
		return;

	var ellipsefactory = moi.command.createFactory( 'ellipsediameter' );
	ellipsefactory.setInput( 0, pointpicker.pt );

	ui.beginUIUpdate();
	ui.hideUI( 'FirstPrompt' );
	ui.showUI( 'SecondPrompt' );
	ui.endUIUpdate();

	pointpicker.clearBindings();
	pointpicker.bindResultPt( ellipsefactory.getInput(1) );

	if ( !GetPoint( pointpicker ) )
		return;

	
	ui.beginUIUpdate();
	ui.hideUI( 'SecondPrompt' );
	ui.showUI( 'ThirdPrompt' );
	ui.endUIUpdate();
	
	pointpicker.clearBindings();
	pointpicker.bindResultPt( ellipsefactory.getInput(2) );
	
	var center = moi.vectorMath.average( ellipsefactory.getInput(0).getValue(), ellipsefactory.getInput(1).getValue() );
	pointpicker.setBasePt( center );
	
	if ( !GetPoint( pointpicker ) )
		return;


	ellipsefactory.commit();
}

DoEllipseDiameter();
